/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationAbstractTasklet;
import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.base.ntfy.PairingEditPanelBean;
import com.ibm.hwmca.base.ntfy.PairingListPanelBean;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.ntfy.AbstractSink;
import com.ibm.hwmca.fw.ntfy.AbstractSource;
import com.ibm.hwmca.fw.ntfy.DuplicateNameException;
import com.ibm.hwmca.fw.ntfy.MonitoredHashMap;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.SourceSinkLink;
import com.ibm.hwmca.fw.ntfy.Startable;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PairingListTasklet
extends NotificationAbstractTasklet {
    private static final String TRACE_MASKT = "XNTYPLTT";
    private static final String TRACE_MASKF = "XNTYPLTF";
    private static final String TRACE_MASKD = "XNTYPLTD";

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> PairingListTasklet.service()");
        String command = (String)request.getData("CommandName");
        if (command == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.serviceInitial(request, response);
        } else if (request.isCanceled() || request.isDisposed() || command.equals("CANCEL")) {
            this.serviceDisposed(request, response);
        } else if (command.equals("CancelButton")) {
            this.serviceCancelButton(request, response);
        } else if (command.equals("OKButton")) {
            this.serviceOKButton(request, response);
        } else if (command.equals("AddButton")) {
            this.serviceAddButton(request, response);
        } else if (command.equals("EditButton")) {
            this.serviceEditButton(request, response);
        } else if (command.equals("DeleteButton")) {
            this.serviceDeleteButton(request, response);
        } else if (command.equals("BounceCommand")) {
            this.serviceBounce(request, response);
        } else {
            this.unknownCommand(response, command);
        }
    }

    private final void serviceInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<> serviceInitial()");
        this.errorId = (short)-32750;
        PairingListPanelBean bean = new PairingListPanelBean();
        Map links = NotificationService.getManager().getLinks();
        Map[] linkMap = new Map[links.size()];
        int i = 0;
        Iterator iterator = links.keySet().iterator();
        while (iterator.hasNext()) {
            linkMap[i] = new HashMap();
            String linkName = (String)iterator.next();
            SourceSinkLink link = (SourceSinkLink)links.get(linkName);
            Set sources = link.getSources();
            Set sinks = link.getSinks();
            String[] sourceNames = new String[sources.size()];
            int z = 0;
            Iterator sourceIterator = sources.iterator();
            while (sourceIterator.hasNext()) {
                sourceNames[z] = ((AbstractSource)sourceIterator.next()).getName();
                ++z;
            }
            String[] sinkNames = new String[sinks.size()];
            z = 0;
            Iterator sinkIterator = sinks.iterator();
            while (sinkIterator.hasNext()) {
                sinkNames[z] = ((AbstractSink)sinkIterator.next()).getName();
                ++z;
            }
            linkMap[i].put("DataMapLinkName", linkName);
            linkMap[i].put("DataMapLinkDesc", link.getDescription());
            linkMap[i].put("DataMapLinkEnabled", new Boolean(link.isEnabled()));
            linkMap[i].put("DataMapLinkSources", sourceNames);
            linkMap[i].put("DataMapLinkSinks", sinkNames);
            ++i;
        }
        bean.setBeanName("PairingListPanel");
        HashMap<String, Map[]> data = new HashMap<String, Map[]>();
        data.put("DataMapArray", linkMap);
        bean.setData(data);
        response.replace("com.ibm.hwmca.base.ntfy.res.NotificationRes", "PairingListPanel", bean);
    }

    void serviceSourcesButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceSourcesButton");
        response.openModalChild(new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.SourcesListTasklet", null));
    }

    void serviceSinksButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceSinksButton");
        response.openModalChild(new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.ntfy.SinksListTasklet", null));
    }

    void serviceOKButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceOKButton");
        this.errorId = (short)-32750;
        String name = (String)request.getData("DataMapName");
        String desc = (String)request.getData("DataMapDesc");
        boolean enabled = (Boolean)request.getData("DataMapEnabledCheckbox");
        String[] selectedSinks = (String[])request.getData("DataMapSinksTable");
        String[] selectedSources = (String[])request.getData("DataMapSourcesTable");
        HashSet sinks = new HashSet();
        HashSet sources = new HashSet();
        SourceSinkLink link = null;
        try {
            int i = 0;
            while (i < selectedSinks.length) {
                sinks.add(NotificationService.getManager().getSinks().get(selectedSinks[i]));
                ++i;
            }
            int i2 = 0;
            while (i2 < selectedSources.length) {
                sources.add(NotificationService.getManager().getSources().get(selectedSources[i2]));
                ++i2;
            }
            link = new SourceSinkLink(name, desc, sources, sinks);
            link.setEnabled(enabled);
            if (this.mode == 2) {
                ((MonitoredHashMap)NotificationService.getManager().getLinks()).replace(name, link);
            } else {
                NotificationService.getManager().getLinks().put(name, link);
            }
            if (link instanceof Startable) {
                try {
                    link.start();
                }
                catch (Exception e) {
                    new FrameworkLog(NotificationErrorIds._logInfo, -32737, e).log(LogAttributes.INFO_LOG);
                }
            }
            response.dispose("PairingEditPanel");
            HashMap<String, Object> updateData = new HashMap<String, Object>();
            if (this.mode == 2) {
                updateData.put("CommandName", "EditButton");
            } else {
                updateData.put("CommandName", "AddButton");
            }
            updateData.put("DataMapLinkName", name);
            updateData.put("DataMapLinkDesc", desc);
            updateData.put("DataMapLinkEnabled", new Boolean(enabled));
            updateData.put("DataMapLinkSinks", selectedSinks);
            updateData.put("DataMapLinkSources", selectedSources);
            this.bounceUpdate("PairingListPanel", updateData);
        }
        catch (DuplicateNameException dne) {
            this.duplicateMessage(name);
            response.noAction();
        }
    }

    void serviceCancelButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceCancelButton");
        this.errorId = (short)-32750;
        response.dispose("PairingEditPanel");
    }

    void serviceAddButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceAddButton");
        this.errorId = (short)-32750;
        this.mode = 1;
        PairingEditPanelBean bean = new PairingEditPanelBean();
        bean.setBeanName("PairingEditPanel");
        HashMap<String, String[]> beanData = new HashMap<String, String[]>();
        Map sinkMap = NotificationService.getManager().getSinks();
        Map sourceMap = NotificationService.getManager().getSources();
        String[] sinks = new String[sinkMap.size()];
        int i = 0;
        Iterator iterator = sinkMap.keySet().iterator();
        while (iterator.hasNext()) {
            sinks[i] = (String)iterator.next();
            ++i;
        }
        String[] sources = new String[sourceMap.size()];
        i = 0;
        Iterator iterator2 = sourceMap.keySet().iterator();
        while (iterator2.hasNext()) {
            sources[i] = (String)iterator2.next();
            ++i;
        }
        beanData.put("DataMapSinksTable", sinks);
        beanData.put("DataMapSourcesTable", sources);
        bean.setData(beanData);
        response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "PairingEditPanel", bean);
    }

    void serviceEditButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceEditButton");
        this.errorId = (short)-32751;
        this.mode = 2;
        PairingEditPanelBean bean = new PairingEditPanelBean();
        bean.setBeanName("PairingEditPanel");
        String linkName = (String)request.getData("TaskletSelectedLink");
        SourceSinkLink link = (SourceSinkLink)NotificationService.getManager().getLinks().get(linkName);
        HashMap<String, Object> beanData = new HashMap<String, Object>();
        Map sinkMap = NotificationService.getManager().getSinks();
        Map sourceMap = NotificationService.getManager().getSources();
        String[] sinks = new String[sinkMap.size()];
        int i = 0;
        Iterator iterator = sinkMap.keySet().iterator();
        while (iterator.hasNext()) {
            sinks[i] = (String)iterator.next();
            ++i;
        }
        String[] sources = new String[sourceMap.size()];
        i = 0;
        Iterator iterator2 = sourceMap.keySet().iterator();
        while (iterator2.hasNext()) {
            sources[i] = (String)iterator2.next();
            ++i;
        }
        String[] selectedSinks = new String[link.getSinks().size()];
        i = 0;
        Iterator iterator3 = link.getSinks().iterator();
        while (iterator3.hasNext()) {
            selectedSinks[i] = ((AbstractSink)iterator3.next()).getName();
            ++i;
        }
        String[] selectedSources = new String[link.getSources().size()];
        i = 0;
        Iterator iterator4 = link.getSources().iterator();
        while (iterator4.hasNext()) {
            selectedSources[i] = ((AbstractSource)iterator4.next()).getName();
            ++i;
        }
        beanData.put("DataMapSinksTable", sinks);
        beanData.put("DataMapSourcesTable", sources);
        beanData.put("DataMapName", linkName);
        beanData.put("DataMapDesc", link.getDescription());
        beanData.put("DataMapEnabledCheckbox", new Boolean(link.isEnabled()));
        beanData.put("DataMapSelectedSink", selectedSinks);
        beanData.put("DataMapSelectedSource", selectedSources);
        bean.setData(beanData);
        response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "PairingEditPanel", bean);
    }

    void serviceDeleteButton(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "<> serviceDeleteButton");
        this.errorId = (short)-32750;
        String linkName = (String)request.getData("TaskletSelectedLink");
        if (this.okToDelete(linkName)) {
            SourceSinkLink link = (SourceSinkLink)NotificationService.getManager().getLinks().get(linkName);
            if (link instanceof Startable) {
                try {
                    link.stop();
                }
                catch (Exception e) {
                    new FrameworkLog(NotificationErrorIds._logInfo, -32736, e).log(LogAttributes.INFO_LOG);
                }
            }
            NotificationService.getManager().getLinks().remove(linkName);
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("CommandName", "DeleteButton");
            response.update("PairingListPanel", updateMap);
        } else {
            response.noAction();
        }
    }
}

